<div class="row">
  <div class="col-md-3">
    <div class="form-group">
      <label>{{ trans('app.form.avatar') }}</label>
      <img src="{{ get_avatar_src($profile, 'medium') }}" class="thumbnail" width="100%" alt="{{ trans('app.avatar') }}">
      @if ($profile->avatarImage)
        <a class="btn btn-xs btn-default confirm ajax-silent" type="submit" href="{{ route('admin.account.deletePhoto') }}"><i class="fa fa-trash-o"></i> {{ trans('app.form.delete_avatar') }}</a>
      @endif
    </div>

    <div class="form-group">
      {!! Form::open(['route' => 'admin.account.updatePhoto', 'files' => true, 'data-toggle' => 'validator']) !!}
      <div class="row">
        <div class="col-md-8 nopadding-right">
          <input type="file" name="image" required />
          <div class="help-block with-errors"></div>
        </div>
        <div class="col-md-4 nopadding-left">
          <button type="submit" class="btn btn-info btn-block">{{ trans('app.form.upload') }}</button>
        </div>
      </div>
      {!! Form::close() !!}
    </div>

    <div class="clearfix spacer30"></div>
    <p>
    <div>
      <i class="fa fa-building-o"></i>

      @if (Auth::user()->isSuperAdmin())
        {{ trans('app.super_admin') }}
      @else
        {{ Auth::user()->role->name }}
      @endif
    </div>

    <i class="fa fa-clock-o"></i>
    {{ trans('app.member_since') . ' ' . Auth::user()->created_at->diffForHumans() }}
    </p>
  </div>

  <div class="col-md-6">
    {!! Form::model($profile, ['method' => 'PUT', 'route' => ['admin.account.update'], 'files' => true, 'id' => 'form', 'data-toggle' => 'validator']) !!}

    <div class="form-group">
      {!! Form::label('name', trans('app.form.full_name') . '*') !!}
      {!! Form::text('name', null, ['class' => 'form-control', 'placeholder' => trans('app.placeholder.full_name'), 'required']) !!}
      <div class="help-block with-errors"></div>
    </div>
    <div class="form-group">
      {!! Form::label('nice_name', trans('app.form.nice_name')) !!}
      {!! Form::text('nice_name', null, ['class' => 'form-control', 'placeholder' => trans('app.placeholder.nice_name')]) !!}
    </div>
    <div class="form-group">
      {!! Form::label('role', trans('app.form.role')) !!}
      {!! Form::text('role', $profile->role->name, ['class' => 'form-control', 'disabled' => 'disabled']) !!}
    </div>
    <div class="form-group">
      {!! Form::label('email', trans('app.form.email_address') . '*') !!}
      {!! Form::email('email', null, ['class' => 'form-control', 'placeholder' => trans('app.placeholder.valid_email'), 'required']) !!}
      <div class="help-block with-errors"></div>
    </div>

    <div class="form-group">
      {!! Form::label('dob', trans('app.form.dob')) !!}
      <div class="input-group">
        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
        {!! Form::text('dob', null, ['class' => 'form-control datepicker', 'placeholder' => trans('app.placeholder.dob')]) !!}
      </div>
    </div>
    <div class="form-group">
      {!! Form::label('sex', trans('app.form.sex')) !!}
      {!! Form::select('sex', ['app.male' => trans('app.male'), 'app.female' => trans('app.female'), 'app.other' => trans('app.other')], null, ['class' => 'form-control select2-normal', 'placeholder' => trans('app.placeholder.sex')]) !!}
    </div>

    <div class="form-group">
      {!! Form::label('description', trans('app.form.biography')) !!}
      {!! Form::textarea('description', null, ['class' => 'form-control summernote-without-toolbar', 'rows' => '2', 'placeholder' => trans('app.placeholder.biography')]) !!}
    </div>

    {!! Form::submit(trans('app.update'), ['class' => 'btn btn-flat btn-new']) !!}
    {!! Form::close() !!}
    <div class="spacer30"></div>
  </div>

  <div class="col-md-3">
    <div class="form-group">
      <label>{{ trans('app.form.address') }}</label>
      @if ($profile->primaryAddress)
        {!! $profile->primaryAddress->toHtml() !!}

        <a class="ajax-modal-btn btn btn-default" href="javascript:void(0)" data-link="{{ route('address.edit', $profile->primaryAddress->id) }}"><i class="fa fa-map-marker"></i> {{ trans('app.update_address') }}</a>
      @else
        <a class="ajax-modal-btn btn btn-default" href="javascript:void(0)" data-link="{{ route('address.create', ['user', $profile->id]) }}"><i class="fa fa-plus-square-o"></i> {{ trans('app.add_address') }}</a>
      @endif
    </div>

    <div class="form-group">
      <a class="ajax-modal-btn btn btn-default" href="javascript:void(0)" data-link="{{ route('admin.account.showChangePasswordForm') }}"><i class="fa fa-lock"></i> {{ trans('app.change_password') }}</a>
    </div>

    @if ($profile->isFromMerchant())
      <hr />
      <div class="form-group">
        <label>{{ trans('app.merchant') }}</label>
        <p class="lead">{{ optional($profile->shop)->name }}</p>

        <label>{{ trans('app.form.logo') }}</label>
        <img src="{{ get_storage_file_url(optional($profile->shop->image)->path, 'small') }}" class="thumbnail" alt="{{ trans('app.logo') }}">
      </div>

      <hr />
      <div class="form-group">
        <label>{{ $profile->shop->getVerificationStatus() }}</label>
        <ul class="list-unstyled lead">
          <li class="{{ $profile->shop->id_verified ? 'text-success' : 'text-muted' }}">
            <i class="fa fa-{{ $profile->shop->id_verified ? 'check' : 'times' }}-circle-o"></i>
            {{ trans('app.id_verified') }}
          </li>
          <li class="{{ $profile->shop->phone_verified ? 'text-success' : 'text-muted' }}">
            <i class="fa fa-{{ $profile->shop->phone_verified ? 'check' : 'times' }}-circle-o"></i>
            {{ trans('app.phone_verified') }}
          </li>
          <li class="{{ $profile->shop->address_verified ? 'text-success' : 'text-muted' }}">
            <i class="fa fa-{{ $profile->shop->address_verified ? 'check' : 'times' }}-circle-o"></i>
            {{ trans('app.address_verified') }}
          </li>
        </ul>

        <span class="spacer30"></span>

        @can('update', $profile->shop->config)
          <a href="{{ route('admin.setting.verify') }}" class="btn btn-block btn-flat btn-success">{{ trans('app.get_verified') }}</a>
        @endcan
      </div>
    @endif
  </div>
</div>
